(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     62681,       1621]
NotebookOptionsPosition[     59847,       1565]
NotebookOutlinePosition[     60190,       1580]
CellTagsIndexPosition[     60147,       1577]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BisectionMWE", "[", 
    RowBox[{"a0_", ",", "b0_", ",", "n_", ",", "f_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"N", "[", "a0", "]"}]}], ";", 
      RowBox[{"b", "=", 
       RowBox[{"N", "[", "b0", "]"}]}], ";", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], "/", "2"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i", "=", "0"}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"f", "[", "a", "]"}], "*", 
          RowBox[{"f", "[", "b", "]"}]}], ">", "0"}], ",", 
        RowBox[{
         RowBox[{
         "Print", "[", "\"\<We cannot continue with the Bisection Method\>\"",
           "]"}], ";", 
         RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Output", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"i", ",", "a", ",", "m", ",", "b", ",", 
          RowBox[{"f", "[", "m", "]"}]}], "}"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"i", "<", "n"}], ",", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Sign", "[", 
             RowBox[{"f", "[", "a", "]"}], "]"}], "\[Equal]", 
            RowBox[{"Sign", "[", 
             RowBox[{"f", "[", "m", "]"}], "]"}]}], ",", 
           RowBox[{"a", "=", "m"}], ",", 
           RowBox[{"b", "=", "m"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"m", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b"}], ")"}], "/", "2"}]}], ";", 
         RowBox[{"i", "++"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Output", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"Output", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "a", ",", "m", ",", "b", ",", 
              RowBox[{"f", "[", "m", "]"}]}], "}"}]}], "]"}]}], ";"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"NumberForm", "[", 
        RowBox[{
         RowBox[{"TableForm", "[", 
          RowBox[{"Output", ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"None", ",", 
              RowBox[{"{", 
               RowBox[{
               "\"\<i\>\"", ",", "\"\<ai\>\"", ",", "\"\<mi\>\"", ",", 
                "\"\<bi\>\"", ",", "\"\<f[mi]\>\""}], "}"}]}], "}"}]}]}], 
          "]"}], ",", "8"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<Root after \>\"", ",", "n", ",", "\"\< iterations = \>\"", ",", 
        RowBox[{"NumberForm", "[", 
         RowBox[{"m", ",", "8"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Accuracy = \>\"", ",", 
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "a"}], ")"}], "/", "2"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Function value at approximated root, f[m]= \>\"", ",", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"f", "[", "m", "]"}], ",", "8"}], "]"}]}], "]"}], ";"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8203846860163174`*^9, 3.8203852275886483`*^9}, 
   3.8203853236577578`*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"72e4d357-1f13-4421-811d-d06cdf9ad76b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"5", "x"}], "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "4"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8203853442353764`*^9, 3.820385375699235*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"e762e534-8005-467b-9248-456a8ed13df2"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVl3c81d8fx699XTLvRSrZKSNUUsk5aRC+RMkoRIjKSFoqGWWWleykjFSS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       "]]},
     Annotation[#, "Charting`Private`Tag$10397#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3, 4}, {-10.999996857143035`, 17.626852982635757`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.820385378065914*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"53a73b1b-1928-404b-9c5b-7b37ff8a7860"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BisectionMWE", "[", 
  RowBox[{"3", ",", "4", ",", "10", ",", "f"}], "]"}]], "Input",
 CellChangeTimes->{{3.8203853984446754`*^9, 3.8203854255534463`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"1ddd58fa-bccc-432b-bcf3-c1bf0dec601d"],

Cell[BoxData["\<\"We cannot continue with the Bisection Method\"\>"], "Print",
 CellChangeTimes->{3.820385428808753*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"f9541ce6-cce0-4ca2-9f27-48e6c35141c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BisectionMWE", "[", 
  RowBox[{"0", ",", "1", ",", "10", ",", "f"}], "]"}]], "Input",
 CellChangeTimes->{{3.82038543069198*^9, 3.820385438849866*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"ad8d63f3-6c3a-4f7e-b922-928e604af1aa"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"i\"\>",
        HoldForm], 
       TagBox["\<\"ai\"\>",
        HoldForm], 
       TagBox["\<\"mi\"\>",
        HoldForm], 
       TagBox["\<\"bi\"\>",
        HoldForm], 
       TagBox["\<\"f[mi]\"\>",
        HoldForm]},
      {
       InterpretationBox["\<\"0\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.5\"\>",
        0.5,
        AutoDelete->True], 
       InterpretationBox["\<\"1.\"\>",
        1.,
        AutoDelete->True], 
       InterpretationBox["\<\"-1.375\"\>",
        -1.375,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"1\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"0.\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.25\"\>",
        0.25,
        AutoDelete->True], 
       InterpretationBox["\<\"0.5\"\>",
        0.5,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.234375\"\>",
        -0.234375,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"2\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"0.\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.125\"\>",
        0.125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.25\"\>",
        0.25,
        AutoDelete->True], 
       InterpretationBox["\<\"0.37695313\"\>",
        0.376953125,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"3\"\>",
        3,
        Editable->False], 
       InterpretationBox["\<\"0.125\"\>",
        0.125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.1875\"\>",
        0.1875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.25\"\>",
        0.25,
        AutoDelete->True], 
       InterpretationBox["\<\"0.069091797\"\>",
        0.069091796875,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"4\"\>",
        4,
        Editable->False], 
       InterpretationBox["\<\"0.1875\"\>",
        0.1875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.21875\"\>",
        0.21875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.25\"\>",
        0.25,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.083282471\"\>",
        -0.083282470703125,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"5\"\>",
        5,
        Editable->False], 
       InterpretationBox["\<\"0.1875\"\>",
        0.1875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.203125\"\>",
        0.203125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.21875\"\>",
        0.21875,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.0072441101\"\>",
        -0.007244110107421875,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"6\"\>",
        6,
        Editable->False], 
       InterpretationBox["\<\"0.1875\"\>",
        0.1875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.1953125\"\>",
        0.1953125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.203125\"\>",
        0.203125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.030888081\"\>",
        0.030888080596923828`,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"7\"\>",
        7,
        Editable->False], 
       InterpretationBox["\<\"0.1953125\"\>",
        0.1953125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.19921875\"\>",
        0.19921875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.203125\"\>",
        0.203125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.011812866\"\>",
        0.011812865734100342`,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"8\"\>",
        8,
        Editable->False], 
       InterpretationBox["\<\"0.19921875\"\>",
        0.19921875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.20117188\"\>",
        0.201171875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.203125\"\>",
        0.203125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.0022820756\"\>",
        0.002282075583934784,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"9\"\>",
        9,
        Editable->False], 
       InterpretationBox["\<\"0.20117188\"\>",
        0.201171875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.20214844\"\>",
        0.2021484375,
        AutoDelete->True], 
       InterpretationBox["\<\"0.203125\"\>",
        0.203125,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.0024815956\"\>",
        -0.0024815956130623817`,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"10\"\>",
        10,
        Editable->False], 
       InterpretationBox["\<\"0.20117188\"\>",
        0.201171875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.20166016\"\>",
        0.20166015625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.20214844\"\>",
        0.2021484375,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.000099904253\"\>",
        -0.00009990425314754248,
        AutoDelete->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableHeadings -> {None, {"i", "ai", "mi", "bi", "f[mi]"}}]]],
  NumberForm[#, 8]& ]], "Print",
 CellChangeTimes->{3.820385439534351*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"1ae40174-2bcb-453c-aa0d-2afdf7d511ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Root after \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" iterations = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox["\<\"0.20166016\"\>",
     0.20166015625,
     AutoDelete->True],
    NumberForm[#, 8]& ]}],
  SequenceForm["Root after ", 10, " iterations = ", 
   NumberForm[0.20166015625, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8203854395473623`*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"ff449807-8c3c-4a0b-91d5-df4bb803cfdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Accuracy = \"\>", "\[InvisibleSpace]", "0.00048828125`"}],
  SequenceForm["Accuracy = ", 0.00048828125],
  Editable->False]], "Print",
 CellChangeTimes->{3.820385439556368*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"c251b65b-6925-437c-841f-c85acd590233"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Function value at approximated root, f[m]= \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox["\<\"-0.000099904253\"\>",
     -0.00009990425314754248,
     AutoDelete->True],
    NumberForm[#, 8]& ]}],
  SequenceForm["Function value at approximated root, f[m]= ", 
   NumberForm[-0.00009990425314754248, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.820385439561371*^9},
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"c06452c5-f89a-454f-8eea-2690e0052e86"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"Exp", "[", "x", "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.820385449341304*^9, 3.820385488489501*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"d7e60132-c800-43ef-bbee-535d64b1e593"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2Hk4VV0XAPBrKsmUJBkKSRnKVBrE1mCICEVKhhSVSimiSPKWjInkFSq9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       "]]},
     Annotation[#, "Charting`Private`Tag$11436#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1, 1}, {-2.1779792663446003`, 1.1892299890526479`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8203854824422145`*^9, 3.8203854911003523`*^9}},
 CellLabel->"Out[31]=",ExpressionUUID->"932d1ee1-bacc-4326-8f58-228c143aefe6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BisectionMWE", "[", 
  RowBox[{"0", ",", "1", ",", "10", ",", "f"}], "]"}]], "Input",
 CellChangeTimes->{{3.820385496564739*^9, 3.8203855037208138`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"8a1ea477-c5d0-4b47-a48c-ea4a5bee17a5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"i\"\>",
        HoldForm], 
       TagBox["\<\"ai\"\>",
        HoldForm], 
       TagBox["\<\"mi\"\>",
        HoldForm], 
       TagBox["\<\"bi\"\>",
        HoldForm], 
       TagBox["\<\"f[mi]\"\>",
        HoldForm]},
      {
       InterpretationBox["\<\"0\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.5\"\>",
        0.5,
        AutoDelete->True], 
       InterpretationBox["\<\"1.\"\>",
        1.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.053221927\"\>",
        0.05322192654030866,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"1\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"0.5\"\>",
        0.5,
        AutoDelete->True], 
       InterpretationBox["\<\"0.75\"\>",
        0.75,
        AutoDelete->True], 
       InterpretationBox["\<\"1.\"\>",
        1.,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.85606114\"\>",
        -0.8560611435856852,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"2\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"0.5\"\>",
        0.5,
        AutoDelete->True], 
       InterpretationBox["\<\"0.625\"\>",
        0.625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.75\"\>",
        0.75,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.3566906\"\>",
        -0.356690603889921,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"3\"\>",
        3,
        Editable->False], 
       InterpretationBox["\<\"0.5\"\>",
        0.5,
        AutoDelete->True], 
       InterpretationBox["\<\"0.5625\"\>",
        0.5625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.625\"\>",
        0.625,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.14129375\"\>",
        -0.1412937453091,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"4\"\>",
        4,
        Editable->False], 
       InterpretationBox["\<\"0.5\"\>",
        0.5,
        AutoDelete->True], 
       InterpretationBox["\<\"0.53125\"\>",
        0.53125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.5625\"\>",
        0.5625,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.041512212\"\>",
        -0.04151221167208241,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"5\"\>",
        5,
        Editable->False], 
       InterpretationBox["\<\"0.5\"\>",
        0.5,
        AutoDelete->True], 
       InterpretationBox["\<\"0.515625\"\>",
        0.515625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.53125\"\>",
        0.53125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.0064753408\"\>",
        0.006475340827341247,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"6\"\>",
        6,
        Editable->False], 
       InterpretationBox["\<\"0.515625\"\>",
        0.515625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.5234375\"\>",
        0.5234375,
        AutoDelete->True], 
       InterpretationBox["\<\"0.53125\"\>",
        0.53125,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.017362025\"\>",
        -0.01736202527677333,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"7\"\>",
        7,
        Editable->False], 
       InterpretationBox["\<\"0.515625\"\>",
        0.515625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.51953125\"\>",
        0.51953125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.5234375\"\>",
        0.5234375,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.0054044018\"\>",
        -0.005404401827669103,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"8\"\>",
        8,
        Editable->False], 
       InterpretationBox["\<\"0.515625\"\>",
        0.515625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.51757813\"\>",
        0.517578125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.51953125\"\>",
        0.51953125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.00054518442\"\>",
        0.0005451844176196374,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"9\"\>",
        9,
        Editable->False], 
       InterpretationBox["\<\"0.51757813\"\>",
        0.517578125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.51855469\"\>",
        0.5185546875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.51953125\"\>",
        0.51953125,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.0024271775\"\>",
        -0.0024271774567166116`,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"10\"\>",
        10,
        Editable->False], 
       InterpretationBox["\<\"0.51757813\"\>",
        0.517578125,
        AutoDelete->True], 
       InterpretationBox["\<\"0.51806641\"\>",
        0.51806640625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.51855469\"\>",
        0.5185546875,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.00094038902\"\>",
        -0.0009403890225676559,
        AutoDelete->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableHeadings -> {None, {"i", "ai", "mi", "bi", "f[mi]"}}]]],
  NumberForm[#, 8]& ]], "Print",
 CellChangeTimes->{3.8203855055130873`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"2c859659-f45d-4b3e-9ea3-2767e18db88e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Root after \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" iterations = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox["\<\"0.51806641\"\>",
     0.51806640625,
     AutoDelete->True],
    NumberForm[#, 8]& ]}],
  SequenceForm["Root after ", 10, " iterations = ", 
   NumberForm[0.51806640625, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8203855055240927`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"26ab0531-d527-49ac-938b-eee11512a315"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Accuracy = \"\>", "\[InvisibleSpace]", "0.00048828125`"}],
  SequenceForm["Accuracy = ", 0.00048828125],
  Editable->False]], "Print",
 CellChangeTimes->{3.8203855055310965`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"15c6528d-8164-4a9c-bd86-42e49ffa1519"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Function value at approximated root, f[m]= \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox["\<\"-0.00094038902\"\>",
     -0.0009403890225676559,
     AutoDelete->True],
    NumberForm[#, 8]& ]}],
  SequenceForm["Function value at approximated root, f[m]= ", 
   NumberForm[-0.0009403890225676559, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.820385505536101*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"3baec3e1-5679-4822-a3a5-ff919132601e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", "x", "-", "10"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.820385527080515*^9, 3.820385533254913*^9}, {
  3.8203856863175955`*^9, 3.820385702941382*^9}, {3.820385740675222*^9, 
  3.820385750710577*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"a0c80b0d-b7ec-4ec3-b886-efffc3503973"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13k4VF8YB3BlGVFZkmwJs6RU1oTKe0lIC0opsiQkFZIWQgqVQiRERBRJ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       "]]},
     Annotation[#, "Charting`Private`Tag$11954#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 3}, {-11.070230018330477`, 46.99999442857161}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8203857516082354`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"4981a6a1-59a8-449f-9c53-fe8959f5809b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BisectionMWE", "[", 
  RowBox[{"2", ",", "3", ",", "12", ",", "f"}], "]"}]], "Input",
 CellChangeTimes->{{3.820385757634488*^9, 3.820385763178418*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"b90a7123-a14b-493f-b5bb-28ce09a2b777"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"i\"\>",
        HoldForm], 
       TagBox["\<\"ai\"\>",
        HoldForm], 
       TagBox["\<\"mi\"\>",
        HoldForm], 
       TagBox["\<\"bi\"\>",
        HoldForm], 
       TagBox["\<\"f[mi]\"\>",
        HoldForm]},
      {
       InterpretationBox["\<\"0\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"2.\"\>",
        2.,
        AutoDelete->True], 
       InterpretationBox["\<\"2.5\"\>",
        2.5,
        AutoDelete->True], 
       InterpretationBox["\<\"3.\"\>",
        3.,
        AutoDelete->True], 
       InterpretationBox["\<\"12.8125\"\>",
        12.8125,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"1\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"2.\"\>",
        2.,
        AutoDelete->True], 
       InterpretationBox["\<\"2.25\"\>",
        2.25,
        AutoDelete->True], 
       InterpretationBox["\<\"2.5\"\>",
        2.5,
        AutoDelete->True], 
       InterpretationBox["\<\"2.6914063\"\>",
        2.69140625,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"2\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"2.\"\>",
        2.,
        AutoDelete->True], 
       InterpretationBox["\<\"2.125\"\>",
        2.125,
        AutoDelete->True], 
       InterpretationBox["\<\"2.25\"\>",
        2.25,
        AutoDelete->True], 
       InterpretationBox["\<\"-1.0310059\"\>",
        -1.031005859375,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"3\"\>",
        3,
        Editable->False], 
       InterpretationBox["\<\"2.125\"\>",
        2.125,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1875\"\>",
        2.1875,
        AutoDelete->True], 
       InterpretationBox["\<\"2.25\"\>",
        2.25,
        AutoDelete->True], 
       InterpretationBox["\<\"0.72975159\"\>",
        0.7297515869140625,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"4\"\>",
        4,
        Editable->False], 
       InterpretationBox["\<\"2.125\"\>",
        2.125,
        AutoDelete->True], 
       InterpretationBox["\<\"2.15625\"\>",
        2.15625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1875\"\>",
        2.1875,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.17494106\"\>",
        -0.1749410629272461,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"5\"\>",
        5,
        Editable->False], 
       InterpretationBox["\<\"2.15625\"\>",
        2.15625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.171875\"\>",
        2.171875,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1875\"\>",
        2.1875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.2712279\"\>",
        0.2712278962135315,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"6\"\>",
        6,
        Editable->False], 
       InterpretationBox["\<\"2.15625\"\>",
        2.15625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1640625\"\>",
        2.1640625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.171875\"\>",
        2.171875,
        AutoDelete->True], 
       InterpretationBox["\<\"0.046611492\"\>",
        0.046611491590738297`,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"7\"\>",
        7,
        Editable->False], 
       InterpretationBox["\<\"2.15625\"\>",
        2.15625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1601563\"\>",
        2.16015625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1640625\"\>",
        2.1640625,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.06454622\"\>",
        -0.06454621977172792,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"8\"\>",
        8,
        Editable->False], 
       InterpretationBox["\<\"2.1601563\"\>",
        2.16015625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1621094\"\>",
        2.162109375,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1640625\"\>",
        2.1640625,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.0090629158\"\>",
        -0.009062915793037973,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"9\"\>",
        9,
        Editable->False], 
       InterpretationBox["\<\"2.1621094\"\>",
        2.162109375,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1630859\"\>",
        2.1630859375,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1640625\"\>",
        2.1640625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.018750376\"\>",
        0.01875037580703065,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"10\"\>",
        10,
        Editable->False], 
       InterpretationBox["\<\"2.1621094\"\>",
        2.162109375,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1625977\"\>",
        2.16259765625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1630859\"\>",
        2.1630859375,
        AutoDelete->True], 
       InterpretationBox["\<\"0.004837755\"\>",
        0.004837755005667077,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"11\"\>",
        11,
        Editable->False], 
       InterpretationBox["\<\"2.1621094\"\>",
        2.162109375,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1623535\"\>",
        2.162353515625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1625977\"\>",
        2.16259765625,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.0021140738\"\>",
        -0.0021140737663891684`,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"12\"\>",
        12,
        Editable->False], 
       InterpretationBox["\<\"2.1623535\"\>",
        2.162353515625,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1624756\"\>",
        2.1624755859375,
        AutoDelete->True], 
       InterpretationBox["\<\"2.1625977\"\>",
        2.16259765625,
        AutoDelete->True], 
       InterpretationBox["\<\"0.0013614672\"\>",
        0.0013614672292625585`,
        AutoDelete->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[2.0999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    {None, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableHeadings -> {None, {"i", "ai", "mi", "bi", "f[mi]"}}]]],
  NumberForm[#, 8]& ]], "Print",
 CellChangeTimes->{3.820385764448862*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"22f15e8b-30da-4d31-8b38-06ce7ec10079"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Root after \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" iterations = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox["\<\"2.1624756\"\>",
     2.1624755859375,
     AutoDelete->True],
    NumberForm[#, 8]& ]}],
  SequenceForm["Root after ", 12, " iterations = ", 
   NumberForm[2.1624755859375, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.820385764455867*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"4539a283-4922-45b5-b5ad-bf8f4352cdf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Accuracy = \"\>", "\[InvisibleSpace]", "0.0001220703125`"}],
  SequenceForm["Accuracy = ", 0.0001220703125],
  Editable->False]], "Print",
 CellChangeTimes->{3.820385764461868*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"085096a5-dff1-4949-8b45-eda00987b0df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Function value at approximated root, f[m]= \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox["\<\"0.0013614672\"\>",
     0.0013614672292625585`,
     AutoDelete->True],
    NumberForm[#, 8]& ]}],
  SequenceForm["Function value at approximated root, f[m]= ", 
   NumberForm[0.0013614672292625585`, 8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.82038576446487*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"44193d1f-b014-4f08-a220-a5e704368c04"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{608, 450},
WindowMargins->{{Automatic, 142}, {24, Automatic}},
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 3645, 95, 314, "Input",ExpressionUUID->"72e4d357-1f13-4421-811d-d06cdf9ad76b"],
Cell[CellGroupData[{
Cell[4228, 119, 516, 14, 48, "Input",ExpressionUUID->"e762e534-8005-467b-9248-456a8ed13df2"],
Cell[4747, 135, 11039, 200, 240, "Output",ExpressionUUID->"53a73b1b-1928-404b-9c5b-7b37ff8a7860"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15823, 340, 258, 4, 28, "Input",ExpressionUUID->"1ddd58fa-bccc-432b-bcf3-c1bf0dec601d"],
Cell[16084, 346, 225, 4, 22, "Print",ExpressionUUID->"f9541ce6-cce0-4ca2-9f27-48e6c35141c2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16346, 355, 253, 4, 28, "Input",ExpressionUUID->"ad8d63f3-6c3a-4f7e-b922-928e604af1aa"],
Cell[CellGroupData[{
Cell[16624, 363, 6043, 210, 187, "Print",ExpressionUUID->"1ae40174-2bcb-453c-aa0d-2afdf7d511ab"],
Cell[22670, 575, 558, 15, 22, "Print",ExpressionUUID->"ff449807-8c3c-4a0b-91d5-df4bb803cfdd"],
Cell[23231, 592, 330, 8, 22, "Print",ExpressionUUID->"c251b65b-6925-437c-841f-c85acd590233"],
Cell[23564, 602, 549, 15, 22, "Print",ExpressionUUID->"c06452c5-f89a-454f-8eea-2690e0052e86"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24162, 623, 526, 14, 48, "Input",ExpressionUUID->"d7e60132-c800-43ef-bbee-535d64b1e593"],
Cell[24691, 639, 7489, 142, 238, "Output",ExpressionUUID->"932d1ee1-bacc-4326-8f58-228c143aefe6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32217, 786, 256, 4, 28, "Input",ExpressionUUID->"8a1ea477-c5d0-4b47-a48c-ea4a5bee17a5"],
Cell[CellGroupData[{
Cell[32498, 794, 6084, 210, 187, "Print",ExpressionUUID->"2c859659-f45d-4b3e-9ea3-2767e18db88e"],
Cell[38585, 1006, 558, 15, 22, "Print",ExpressionUUID->"26ab0531-d527-49ac-938b-eee11512a315"],
Cell[39146, 1023, 332, 8, 22, "Print",ExpressionUUID->"15c6528d-8164-4a9c-bd86-42e49ffa1519"],
Cell[39481, 1033, 546, 15, 22, "Print",ExpressionUUID->"3baec3e1-5679-4822-a3a5-ff919132601e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40076, 1054, 632, 17, 48, "Input",ExpressionUUID->"a0c80b0d-b7ec-4ec3-b886-efffc3503973"],
Cell[40711, 1073, 10339, 189, 237, "Output",ExpressionUUID->"4981a6a1-59a8-449f-9c53-fe8959f5809b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51087, 1267, 254, 4, 28, "Input",ExpressionUUID->"b90a7123-a14b-493f-b5bb-28ce09a2b777"],
Cell[CellGroupData[{
Cell[51366, 1275, 7008, 242, 217, "Print",ExpressionUUID->"22f15e8b-30da-4d31-8b38-06ce7ec10079"],
Cell[58377, 1519, 559, 15, 22, "Print",ExpressionUUID->"4539a283-4922-45b5-b5ad-bf8f4352cdf3"],
Cell[58939, 1536, 334, 8, 22, "Print",ExpressionUUID->"085096a5-dff1-4949-8b45-eda00987b0df"],
Cell[59276, 1546, 543, 15, 22, "Print",ExpressionUUID->"44193d1f-b014-4f08-a220-a5e704368c04"]
}, Open  ]]
}, Open  ]]
}
]
*)

